// Lab09: Design the controller for a given system using 
// Lyapunov design approach.


//              scilab - 5.5.2
//              Operating System : Windows 7, 32-bit
//------------------------------------------------------------------------

//Clean the environment
xdel(winsid());//close all graphics Windows clear ;
clear;
clc;

//------------------------------------------------------------------------
//system dicription
A=[0 1;0.5 -0.5]
B=[0 1]';
C=[1 0];
D=0;

//system model

sys=syslin ('c',A,B,C,D);
//------------------------------------------------------------------------

//controller design
//here alpha1=1.5, alpha2=2;
alpha1=1.5;
alpha2=2;
b2=2;
//by design
k1=1+alpha1;
k2=abs(alpha2)+3 // condition is k2>|alpha2|
K=inv(b2)*[k1 k2];

//------------------------------------------------------------------------
//closed loop system model

Ac=A-B*K
sysc=syslin ('c',A-B*K,B,C,D);

//------------------------------------------------------------------------

//Simulation

x0=[1 0.5]'; //initial Condition
t=0:0.1:5; //simulation time
u=zeros(1,length(t)); //no input
[y x]=csim(u,t,sys,x0); //open loop system

tc=0:0.1:20; //simulation time
uc=zeros(1,length(tc)); //no input
[yc xc]=csim(uc,tc,sysc,x0); //closed loop system

//------------------------------------------------------------------------

//Open and closed loop state responses
plot(t',x'); //open loop

//Title, labels and grid to the figure

//figure handel settings
f=get("current_figure"); //Current figure handle
f.background=8; //make the figure window background white
l=f.children(1); 
l.background=8 ;//make the text background white
id=color('grey');
xgrid(id);

title('Open loop state responses','fontsize',3)
xlabel('$t (sec.)$','fontsize',3)
ylabel (["$x_1(t)$","$x_2(t)$"] , 'fontsize',3)
h=legend("$x_1(t)$","$x_2(t)$",4);
h.font_size=3;
h.fill_mode='off'

figure,
plot(tc',xc'); //closed loop
//Title, labels and grid to the figure
exec .\fig_settings.sci; // custom script for setting figure properties
title('Closed loop state responses','fontsize',3)
xlabel('$t (sec.)$','fontsize',3)
ylabel (["$x_1(t)$","$x_2(t)$"] , 'fontsize',3)
h=legend("$x_1(t)$","$x_2(t)$");
h.font_size=3;
h.fill_mode='off'

//------------------------------------------------------------------------

//Open and closed loop state trajectories
figure,
plot(x(1,:),x(2,:),'r--');
plot(xc(1,:),xc(2,:));
zoom_rect([-1 -1 2 3])

//Title, labels and grid to the figure

//figure handel settings
f=get("current_figure"); //Current figure handle
f.background=8; //make the figure window background white
l=f.children(1); 
l.background=8 ;//make the text background white
id=color('grey');
xgrid(id);
title('Open and Closed loop state trajectories','fontsize',3)
xlabel("$x_1(t)$",'fontsize',3);
ylabel ("$x_2(t)$", 'fontsize',3);
f=gca();
f.x_location = "origin"
f.y_location = "origin"
h=legend("Oen loop","Closed loop",4);
h.font_size=2;
h.fill_mode='off'

//------------------------------------------------------------------------
